//////////////////////////////////////////////////////////////////////////////
//
//  Copyright 2017 Autodesk, Inc.  All rights reserved.
//
//  Use of this software is subject to the terms of the Autodesk license 
//  agreement provided at the time of installation or download, or which 
//  otherwise accompanies this software in either electronic or hard copy form.   
//
//////////////////////////////////////////////////////////////////////////////

#pragma once

#include <modstack.h>
#include <iparamb2.h>

#include <MAXtoA_TranslationInterface.h>

#define MAXtoATestModifier_CLASS_ID	Class_ID(0x97532134, 0x9c8a2134)

using namespace Max::ArnoldTranslator;

class MAXtoATestModifier;

class MAXtoATestModifier_translationInterface : public MAXtoA_TranslationInterface
{
public:
    MAXtoATestModifier_translationInterface(MAXtoATestModifier* mod);

    virtual Arnold_translation::TranslationInterface_Result Translate(INode* node,
        Arnold_translation* arnold_translation,
        const TimeValue translationTime,
        Interval& newValidity) override;

private:
    MAXtoATestModifier* m_mod;
};


class MAXtoATestModifier : public Modifier
{
public:
    static ClassDesc2& GetClassDesc();
    
    MAXtoATestModifier();
    virtual ~MAXtoATestModifier();

    virtual void DeleteThis() { delete this; }

    // From Animatable
    virtual const TCHAR *GetObjectName() { return _T("MAXtoATestModifier"); }

    virtual ChannelMask ChannelsUsed() { return GEOM_CHANNEL; }
    virtual ChannelMask ChannelsChanged() { return GEOM_CHANNEL; }

    virtual void ModifyObject(TimeValue t, ModContext &mc, ObjectState *os, INode *node);
    virtual void NotifyInputChanged(const Interval& changeInt, PartID partID, RefMessage message, ModContext *mc);

    Class_ID InputType() { return defObjectClassID; }
    virtual CreateMouseCallBack* GetCreateMouseCallBack() { return NULL; }

    virtual RefResult NotifyRefChanged(const Interval& changeInt, RefTargetHandle hTarget, PartID& partID, RefMessage message, BOOL propagate);

    virtual Class_ID ClassID() { return MAXtoATestModifier_CLASS_ID; }
    virtual SClass_ID SuperClassID() { return OSM_CLASS_ID; }
    virtual void GetClassName(TSTR& s);

    virtual void* GetInterface(ULONG id) override;
    virtual BaseInterface* GetInterface(Interface_ID id) override;

private:
    MAXtoATestModifier_translationInterface m_ti;
};
